<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <!-- favicon -->
    <link rel="icon" type="image/png" href="assets/images/smart.png" />
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="assets/vendors/bootstrap/css/bootstrap.min.css" media="all" />
            <link rel="stylesheet" href="assets/css/style.css">
    <!-- Fonts Awesome CSS -->
    <link rel="stylesheet" type="text/css" href="assets/vendors/fontawesome/css/all.min.css" />
    <!-- jquery-ui css -->
    <link rel="stylesheet" type="text/css" href="assets/vendors/jquery-ui/jquery-ui.min.css" />
    <!-- modal video css -->
    <link rel="stylesheet" type="text/css" href="assets/vendors/modal-video/modal-video.min.css" />
    <!-- light box css -->
    <link rel="stylesheet" type="text/css" href="assets/vendors/lightbox/dist/css/lightbox.min.css" />
    <!-- slick slider css -->
    <link rel="stylesheet" type="text/css" href="assets/vendors/slick/slick.css" />
    <link rel="stylesheet" type="text/css" href="assets/vendors/slick/slick-theme.css" />
    <!-- google fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,400&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,400&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer"
    />
    <!-- Custom CSS -->
    <link rel="stylesheet" type="text/css" href="style.css" />
    <link rel="stylesheet" type="text/css" href="custom.css" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <title translate="no">Viajerosbaratos</title>
    <style>
    .trip-search-section .trip-search-inner {
    margin:10px;
  }
      .input_select {
         background-color: #F8F8F8 !important;
         color: #383838;
         border: none !important;
         height: 50px !important;
         padding: 0 15px;
         width: 100%;
         -webkit-box-shadow: none;
         -moz-box-shadow: none;
         -ms-box-shadow: none;
         -o-box-shadow: none;
         box-shadow: none !important;
         line-height: 1.6;
         border-radius: 0 !important;
      }
      .input_select, .select2-container--default .select2-selection--single .select2-selection__arrow {
         height: 48px !important;
      }
      .input_select, .select2-container--default .select2-selection--single .select2-selection__rendered {
         line-height: 50px !important;
      }
      .nav-tabs .nav-item {
        text-align: center;
        width: 50%; /* Adjust to your preference */
      }

      .nav-tabs .nav-link {
        border: none;
        padding: 10px 15px; /* Adjust padding */
        font-weight: bold;
        color: #333; /* Regular tab color */
        background-color: transparent; /* Remove any background */
      }

      .nav-tabs .nav-link.active {
        color: #fff; /* Active tab text color */
        background-color: #F56960; /* Active tab background color */
        border-radius: 0; /* Remove border radius */
      }
      .box-container {
          border: 1px solid #ddd;
          padding: 20px;
          margin-bottom: 20px;
      }
      .global-container {
          display: flex;
          flex-wrap: wrap; /* Allow wrapping for responsiveness */
          position: relative;
      }
      .vertical-hr {
          border-left: 1px solid #ddd;
          height: 100%;
          position: absolute;
          left: 70%;
          top: 0;
          bottom: 0;
      }
      @media (max-width: 768px) {
          .vertical-hr {
              display: none; /* Hide the vertical line on small screens */
          }
      }
      .container-70 {
          width: 70%;
          padding-right: 20px;
          flex: 0 0 70%;
      }
      .container-30 {
          width: 30%;
          padding-left: 20px;
          flex: 0 0 30%;
          display: flex;
          justify-content: center;
          align-items: center;
          flex-direction: column;
      }
      @media (max-width: 768px) {
          .container-70, .container-30 {
              width: 100%; /* Full width on smaller screens */
              flex: 0 0 100%;
              padding-left: 0;
              padding-right: 0;
          }
      }
      .flight-logo {
          width: 30px;
          height: auto;
      }
      .card-header {
          background-color: #F56960;
          color: #fff;
      }
      .date-badge {
          background-color: #ffedd1;
          padding: 5px;
          border-radius: 5px;
          color: black;
      }
      .flight-info {
          background-color: #f8f9fa;
          padding: 15px;
          border-radius: 10px;
          margin-bottom: 15px;
      }
      .segment-details {
          display: flex;
          align-items: center;
          margin-bottom: 10px;
          flex-wrap: wrap;
      }
      .segment-details img {
          margin-right: 10px;
      }
      .connector {
          position: relative;
          margin-left: 20px;
      }
      .connector::before {
          content: '';
          position: absolute;
          left: -10px;
          top: 0;
          bottom: 0;
          width: 2px;
          background-color: #007bff;
      }
      .waypoint {
          color: #007bff;
      }
      .layover {
          background-color: #e9ecef;
          padding: 10px;
          border-radius: 10px;
          margin-top: 10px;
          margin-bottom: 10px;
          text-align: center;
          width: 100%;
      }
      span {
          color: black;
      }
      select {
          border: 1px solid #d9d9d9 !important;
          height: 48px !important;
      }
      select.is-invalid {
          border-color: #dc3545 !important;
          border-top-color: rgb(220, 53, 69);
          border-right-color: rgb(220, 53, 69);
          border-bottom-color: rgb(220, 53, 69);
          border-left-color: rgb(220, 53, 69);
          padding-right: calc(1.5em + .75rem);
          background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' stroke='%23dc3545' viewBox='0 0 12 12'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e");
          background-repeat: no-repeat;
          background-position: right calc(.375em + .1875rem) center;
          background-size: calc(.75em + .375rem) calc(.75em + .375rem);
      }
      @media (max-width: 576px) {
          .segment-details {
              flex-direction: column;
              align-items: flex-start;
          }
          .connector::before {
              left: -20px;
          }
          .date-badge {
              font-size: 0.8rem;
              padding: 3px;
          }
          .layover {
              margin-top: 20px;
          }
      }
      .passenger-selector {
          display: none;
          position: absolute;
          background-color: #fff;
          border: 1px solid #ccc;
          padding: 10px;
          width: 300px;
          z-index: 1000;
      }
      .passenger-selector-counter {
          display: flex;
          align-items: center;
          justify-content: space-between;
          width: 120px;
      }
      .passenger-selector-counter button {
          background-color: #007bff;
          color: #fff;
          border: none;
          width: 30px;
          height: 30px;
          text-align: center;
          font-size: 18px;
          border-radius: 50%;
      }
      .passenger-selector-counter span {
          font-size: 18px;
          width: 30px;
          text-align: center;
      }
      .filter-section {
          padding: 10px;
          background-color: #f8f9fa; /* Light grey background for the filter sections */
          border-radius: 5px;
          box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.1);
      }

      .filter-title {
          margin-bottom: 15px;
          font-weight: bold;
      }

      .form-check {
          margin-bottom: 10px;
      }

      @media (max-width: 768px) {
          .filter-section {
              margin-bottom: 20px;
          }
      }
    </style>
  </head>
  <body class="home">
    <div id="siteLoader" class="site-loader">
      <div class="preloader-content">
        <img src="assets/images/loader1.gif" alt="" />
      </div>
    </div>
    <div id="page" class="full-page">
      <header>
            <div class="header-top">
                <div class="container custom-container">
                    <div class="row">
                        <div class="col-xl-4">
                            <div class="header-top-left">
                                                            </div>
                        </div>
                        <div class="col-xl-8">
                            <div class="header-top-right">
                                <ul>
                                                                         <li><a href="tel:+971-55-873-2462"><i class="fas fa-mobile-alt"></i>+971-55-873-2462</a></li>
                                                                                                           
                                                                    </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="sticky-header" class="menu-area transparent-header">
                <div class="container custom-container">
                    <div class="row">
                        <div class="col-12 mobile">
                            <div class="mobile-nav-toggler"><span class="sign"><i class="fa-regular"></i></span> <i class="fas fa-bars"></i></div>
                            <div class="menu-wrap">
                                <nav class="menu-nav">
                                    <div class="logo"><a class="head" href="/"><img src="assets/images/viajerosbaratos.png" alt="logo" width="200" height="36"></a>
                                      <a class="scrol" href="/"><img src="assets/images/viajerosbaratos.png" alt="logo" width="200" height="36"></a></div>
                                    <div class="navbar-wrap main-menu d-none d-lg-flex">
                                        <ul class="navigation">
                                            <li><a href="/">Hogar</a></li>
                                            <li><a href="about-us.php">Sobre nosotras</a></li>
                                            <li><a href="privacy-policy">Política de privacidad</a></li>
                                            <li><a href="contact.php">Contacta</a></li>

                                        </ul>
                                    </div>
                                    <div class="header-action d-none d-md-block">
                                                                                 <ul>
                                            <li class="header-btn"><a href="tel:+971-55-873-2462" class="btn"><i class="fa-solid fa-phone-volume blink"></i>+971-55-873-2462</a></li>
                                        </ul>
                                                                             </div>
                                </nav>
                            </div>
                            <!-- Mobile Menu  -->
                            <div class="mobile-menu">
                                <nav class="menu-box">
                                    <div class="close-btn"><i class="fa-solid fa-xmark"></i></div>
                                    <div class="nav-logo"><a href="/"><img src="assets/images/viajerosbaratos.png" alt="logo"></a>
                                    </div>
                                    <div class="menu-outer">
                                        <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                                    </div>
                                    <!-- <div class="social-links">
                                        <ul class="clearfix">
                                            <li><a href="#"><span class="fab fa-twitter"></span></a></li>
                                            <li><a href="#"><span class="fab fa-facebook-f"></span></a></li>
                                            <li><a href="#"><span class="fab fa-pinterest-p"></span></a></li>
                                            <li><a href="#"><span class="fab fa-instagram"></span></a></li>
                                            <li><a href="#"><span class="fab fa-youtube"></span></a></li>
                                        </ul>
                                    </div> -->
                                </nav>
                            </div>
                            <div class="menu-backdrop"></div>
                            <!-- End Mobile Menu -->
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <!-- header-area-end -->
      <main id="content" class="site-main">
        <!-- Inner Banner html start-->
        <section class="inner-banner-wrap">
          <div class="inner-baner-container" style="background-image: url(assets/images/policy.jpg);">
            <div class="container">
              <div class="inner-banner-content">
                <h1 class="inner-title">Flight Search</h1>
              </div>
            </div>
          </div>
        </section>
        <div class="step-section cart-section">
          <div class="container">
            <div class="step-link-wrap"></div>

            <div class="trip-search-section shape-search-section">
              <div class="container">
                <form action = "flight-search.php" method = "GET">
                  <input type="hidden" id="sourceName" name="sourceAirportName" />
                  <input type="hidden" id="destinationName" name="destinationAirportName" />
                  <input type="hidden" id="sourceEntity" name="sourceEntity" />
                  <input type="hidden" id="destinationEntity" name="destinationEntity" />
                  <input type="hidden" id="adults" name="adults" />
                  <input type="hidden" id="children" name="childrens" />
                  <input type="hidden" id="infants" name="infants" />
                  <input type="hidden" id="flightClass" name="flight_class" value="economy" />
                  <input type="hidden" name="tripType" value="ONE_WAY">
                  <div class="trip-search-inner white-bg d-flex">
                    <ul class="col-lg-12 nav nav-tabs" id="tripTypeTabs" role="tablist" style="margin-bottom: 20px;">
                      <li class="nav-item">
                        <a class="nav-link active" id="oneway-tab" data-toggle="tab" href="#oneway" role="tab" aria-controls="oneway" aria-selected="true">One Way</a>
                      </li>
                      <li class="nav-item">
                        <a class="nav-link" id="roundtrip-tab" data-toggle="tab" href="#roundtrip" role="tab" aria-controls="roundtrip" aria-selected="false">Round Trip</a>
                      </li>
                    </ul>
                    <div class="tab-content col-lg-12" id="tripTypeContent">
                      <div class="tab-pane fade active show" id="oneway" role="tabpanel" aria-labelledby="oneway-tab">
                        <div style="display: flex; justify-content: center; align-items: flex-end; flex-wrap: wrap;">
                          <div class="input-group">
                            <label for="source">Origin Airport*</label>
                            <select type="text" class="source" name="sourceAirportCode" placeholder="Enter Origin"></select>
                          </div>
                          <div class="input-group">
                            <label for="destination">Destination Airport*</label>
                            <select type="text" class="destination" name="destinationAirportCode" placeholder="Enter Destination"></select>
                          </div>
                          <div class="input-group">
                            <label for="pax-number">Passengers*</label>
                            <input type="text" id="pax-number" class="togglePassenger" name="numAdults" placeholder="No. of People">
                            <div class="passenger-selector">
                                <div class="form-group">
                                    <label>Adults</label>
                                    <div class="passenger-selector-counter">
                                        <button type="button" class="passenger-selector-adults-minus">-</button>
                                        <span class="passenger-selector-adults-count">1</span>
                                        <button type="button" class="passenger-selector-adults-plus">+</button>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Children</label>
                                    <div class="passenger-selector-counter">
                                        <button type="button" class="passenger-selector-children-minus">-</button>
                                        <span class="passenger-selector-children-count">0</span>
                                        <button type="button" class="passenger-selector-children-plus">+</button>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Infants</label>
                                    <div class="passenger-selector-counter">
                                        <button type="button" class="passenger-selector-infants-minus">-</button>
                                        <span class="passenger-selector-infants-count">0</span>
                                        <button type="button" class="passenger-selector-infants-plus">+</button>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="class">Class</label>
                                    <select class="form-control passenger-selector-class">
                                        <option value="economy">Economy</option>
                                        <option value="premium_economy">Premium Economy</option>
                                        <option value="business">Business</option>
                                        <option value="first">First</option>
                                    </select>
                                </div>
                                <button class="btn btn-primary passenger-selector-done-button" type="button">Done</button>
                            </div>
                          </div>
                          <div class="input-group width-col-3">
                            <label for="checkin-date">Checkin Date*</label>
                            <i class="far fa-calendar"></i>
                            <input class="input-date-picker" type="text" id="checkin-date1" name="date" placeholder="MM / DD / YY" autocomplete="off" readonly="readonly">
                          </div>
                          <div class="input-group width-col-3">
                            <label class="screen-reader-text" for="search-submit">Search</label>
                            <button type="submit" class="btn-theme">INQUIRE NOW</button>
                          </div>
                        </div>
                      </div>
                      <div class="tab-pane fade" id="roundtrip" role="tabpanel" aria-labelledby="roundtrip-tab">
                        <div class="tab-pane fade active show" id="oneway" role="tabpanel" aria-labelledby="oneway-tab">
                          <div style="display: flex; justify-content: center; align-items: flex-end; flex-wrap: wrap;">
                            <div class="input-group">
                              <label for="source">Origin Airport*</label>
                              <select type="text" class="source" name="sourceAirportCode" placeholder="Enter Origin"></select>
                            </div>
                            <div class="input-group">
                              <label for="destination">Destination Airport*</label>
                              <select type="text" class="destination" name="destinationAirportCode" placeholder="Enter Destination"></select>
                            </div>
                            <div class="input-group">
                              <label for="pax-number">Passengers*</label>
                              <input type="text" id="pax-number" class="togglePassenger" name="numAdults" placeholder="No. of People">
                              <div class="passenger-selector">
                                  <div class="form-group">
                                      <label>Adults</label>
                                      <div class="passenger-selector-counter">
                                          <button type="button" class="passenger-selector-adults-minus">-</button>
                                          <span class="passenger-selector-adults-count">1</span>
                                          <button type="button" class="passenger-selector-adults-plus">+</button>
                                      </div>
                                  </div>
                                  <div class="form-group">
                                      <label>Children</label>
                                      <div class="passenger-selector-counter">
                                          <button type="button" class="passenger-selector-children-minus">-</button>
                                          <span class="passenger-selector-children-count">0</span>
                                          <button type="button" class="passenger-selector-children-plus">+</button>
                                      </div>
                                  </div>
                                  <div class="form-group">
                                      <label>Infants</label>
                                      <div class="passenger-selector-counter">
                                          <button type="button" class="passenger-selector-infants-minus">-</button>
                                          <span class="passenger-selector-infants-count">0</span>
                                          <button type="button" class="passenger-selector-infants-plus">+</button>
                                      </div>
                                  </div>
                                  <div class="form-group">
                                      <label for="class">Class</label>
                                      <select class="form-control passenger-selector-class">
                                          <option value="economy">Economy</option>
                                          <option value="premium_economy">Premium Economy</option>
                                          <option value="business">Business</option>
                                          <option value="first">First</option>
                                      </select>
                                  </div>
                                  <button class="btn btn-primary passenger-selector-done-button" type="button">Done</button>
                              </div>
                            </div>
                            <div class="input-group width-col-3">
                              <label for="checkin-date">Checkin Date*</label>
                              <i class="far fa-calendar"></i>
                              <input class="input-date-picker" type="text" id="checkin-date2" name="date" placeholder="MM / DD / YY" autocomplete="off" readonly="readonly">
                            </div>
                            <div class="input-group width-col-3">
                              <label for="checkin-date">Return Date*</label>
                              <i class="far fa-calendar"></i>
                              <input class="input-date-picker" type="text" id="returnDate" name="returnDate" placeholder="MM / DD / YY" autocomplete="off" readonly="readonly">
                            </div>
                            <div class="input-group width-col-3">
                              <label class="screen-reader-text" for="search-submit">Search</label>
                              <button type="submit" class="btn-theme">INQUIRE NOW</button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>

          </div>
          <div class="confirmation-inner">
            <div class="row">
              <div class="col-lg-12 right-sidebar">
                <div class="container">
                  <!-- Main Content: Left Side - Filter, Right Side - Flight List -->
                  <div class="row">
                    <!-- Left Side: Filter -->
                    <div class="col-md-3">
                      <h3>Filters</h3>
                    </div>

                    <!-- Right Side: List of Flights -->
                    <div class="col-md-9 flight-list">
                      <h3>Available Flights</h3>
                      <div class="row">
                        <div class="col-md-12" id="flights">
                          <!-- Flights will be added here -->
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- callback html end -->
        </div>
      </main>
<footer>
    <div class="footer-area footer-bg">
        <!-- New Airlines Section -->
<div class="footer-airlines">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="footer-widget privacy">
                    <div class="fw-title text-center">
                        <h3>Aerolíneas Populares</h3>
                    </div>
                    <div class="fw-link">
                        <div class="airlines-grid">
                            <div class="airlines-row">
                                <a href="american.php">Aerolínea Estadounidense</a>
                                <a href="frontier-airlines.php">Aerolíneas Frontier</a>
                                <a href="iberia-airline.php">Aerolíneas Iberia</a>
                            </div>
                            <div class="airlines-row">
                                <a href="jetblue-airline.php">Jetblue Airline</a>
                                <a href="spirit-airlines.php">Aerolíneas Spirit</a>
                                <a href="united-airline.php">Aerolíneas United</a>
                            </div>
                            <div class="airlines-row">
                                <a href="viva-airline.php">Aerolíneas Viva</a>
                                <a href="volaris-airlines.php">Aerolíneas Volaris</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Airlines Section -->
        
        <div class="footer-top">
            <div class="container">
                <div class="row">
                    <div class="col-xl-3 col-lg-4 col-md-6">
                        <div class="footer-widget">
                            <div class="footer-logo">
                                <a href="/"><img src="assets/images/viajerosbaratos.png" alt="footerlogo" width="278" height="49"></a>
                            </div>
                            <div class="footer-content">
                                <p><span translate="no"> viajerosbaratos.com </span>es una compañía de viajes global que ofrece reservas de vuelos independiente asequibles, experiencias de viaje personalizadas y soporte las 24 horas, los 7 días de la semana, lo que garantiza viajes fluidos y memorables en todo el mundo.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-2 col-lg-4 col-sm-4 ftr-hed">
                        <div class="footer-widget privacy">
                            <div class="fw-title">
                                <h4 class="title">Enlaces Rápidos</h4>
                            </div>
                            <div class="fw-link">
                                <ul>
                                  <li><a href="last-minute-trip">Viaje de último minuto</a></li>
                                  <li><a href="student-trips">Viajes para estudiantiles</a></li>
                                  <li><a href="travel-for-seniors">Viajes para mayores</a></li>
                                  <li><a href="military-trips">Viajes militares</a></li>
                                  <li><a href="domestic-flights">Vuelos domésticos</a></li>
                                  <li><a href="one-way-flights">Vuelos de ida</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-4 col-sm-4 ftr-hed">
                        <div class="footer-widget privacy">
                            <div class="fw-title">
                                <h4 class="title">Destinos populares</h4>
                            </div>
                            <div class="fw-link">
                                <ul>
                                  <li><a href="orlando">Orlando</a></li>
                                  <li><a href="fort-lauderdale">Fort Lauderdale</a></li>
                                  <li><a href="atlanta">Atlanta</a></li>
                                  <li><a href="los-angeles">Los Angeles</a></li>
                                  <li><a href="saint-john">San Juan</a></li>
                                  <li><a href="miami">Miami</a></li>
                                  <li><a href="houston">Houston</a></li>
                                  <li><a href="newark">Newark</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-4 col-sm-4 ftr-hed">
                        <div class="footer-widget privacy">
                            <div class="fw-title">
                                <h4 class="title">Enlaces útiles</h4>
                            </div>
                            <div class="fw-link">
                                <ul>
                                  <li><a href="about-us.php">Sobre nosotras</a></li>
                                  <li><a href="contact.php">Contacta con nosotras</a></li>
                                  <li><a href="cancelation">Cancelación</a></li>
                                  <li><a href="privacy-policy">Política de privacidad</a></li>
                                  <li><a href="sitemap">Mapa del sitio</a></li>
                                  <li><a href="terms-conditions">Términos y condiciones</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4 col-sm-8 ftr-hed">
                        <div class="footer-widget cnt-ftr">
                            <div class="fw-title">
                                <h4 class="title">Contacta con nosotras</h4>
                            </div>
                            <div class="footer-contact">
                              <ul>
                                <li><p><b>DIRECCIÓN</b><br> </p></li>
                                <li><a href="tel:+971-55-873-2462"><i class="fa fa-phone-alt"></i> +971-55-873-2462</a></li>
                                <li>
                                    <a href="mailto:info@viajerosbaratos.com">
                                        <i class="fa fa-envelope"></i> info@viajerosbaratos.com
                                    </a>
                                </li>
                                <li><a href=""><i class="fa fa-map-marker-alt"></i> Address :20178-001 IFZA Business Park, DDP, Silicon Oasis, Dubai, United Arab Emirates</a></li>
                              </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <p class="disclaimer"><strong>Descargo de responsabilidad:</strong> Estimados invitados, Bienvenidos a Viajerosbaratos. La información contenida en esta página está destinada únicamente a ser ejemplo. El sitio tiene información actualizada, precisa, completa y confiable que hemos trabajado arduamente para mantenerla actualizada. <span translate="no"> viajerosbaratos.com </span>generalmente analiza muchas cosas, como qué tan precisa es la información, cómo se conecta a otros sitios, qué tan disponible está el servicio y el contenido generado por el usuario. Garantizamos claridad y establecemos expectativas claras para todos los involucrados, minimizando sorpresas inesperadas. Si tiene alguna pregunta.</p>
              <div class="trust" bis_skin_checked="1">
                        <ul class="ftr-trustpilot">
                        <li><img src="assets/images/asta-logo.png" alt="asta" width="81" height="24"></li>
                        <li><img src="assets/images/cloudfare.png" alt="cloudfare" width="94" height="33"></li>
                        <li><img src="assets/images/godaddy-ssl.png" alt="godaddy" width="95" height="24"></li>
                        <li><img src="assets/images/mac2.png" alt="mac2" width="59" height="24"></li>
                        <li><img src="assets/images/newlogo.png" alt="newlogo" width="180" height="31"></li>
                        <li><img src="assets/images/arc.png" alt="trust" width="40" height="20"></li>
                        <li><img src="assets/images/trustpilot-logo.png" alt="trustpilot" width="115" height="28"></li>
                        </ul>
                        </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                    <div class="col-lg-12">
                        <div class="copyright-text text-center">
                            <p>Derechos de autor © 2024 <span translate="no">viajerosbaratos.com</span> | Reservados todos los derechos | Empresa matriz: <span translate="no"> Mark8er FZCO</span></p>
                        </div>
                    </div>
            </div>
        </div>
    </div>
</footer>



<style>
    /* Airlines Section Styles */
    .footer-airlines {
        background: #000000;
        padding: 30px 0;
        border-bottom: 1px solid #000000;
    }
    
    .fw-title h3 {
        color: #ffffff;
        font-size: 24px;
        font-weight: 600;
        margin-bottom: 20px;
        text-transform: uppercase;
    }
    
    .airlines-grid {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 15px;
        max-width: 800px;
        margin: 0 auto;
    }
    
    .airlines-row {
        display: flex;
        justify-content: center;
        gap: 30px;
        width: 100%;
    }
    
    .airlines-row a {
        color: #ffffff;
        text-decoration: none;
        font-size: 16px;
        font-weight: 500;
        padding: 8px 15px;
        border: 1px solid #333;
        border-radius: 4px;
        transition: all 0.3s ease;
        min-width: 180px;
        text-align: center;
    }
    
    .airlines-row a:hover {
        background: #333;
        color: #fff;
        transform: translateY(-2px);
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        .airlines-row {
            flex-direction: column;
            gap: 10px;
            align-items: center;
        }
        
        .airlines-row a {
            width: 80%;
        }
    }
</style>
      <a id="backTotop" href="#" class="to-top-icon">
        <i class="fas fa-chevron-up"></i>
      </a>
      <!-- custom search field html -->
      <div class="header-search-form">
        <div class="container">
          <div class="header-search-container">
            <form class="search-form" role="search" method="get">
              <input type="text" name="s" placeholder="Enter your text..." />
            </form>
            <a href="#" class="search-close">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div>
      </div>
      <!-- header html end -->
    </div>

   

    <!-- JavaScript -->
    <script src="assets/js/jquery.js"></script>
    <script src="http://cdnjs.cloudflare.com/ajax/libs/waypoints/2.0.3/waypoints.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.30.1/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.0.6/dist/umd/popper.min.js"></script>
    <script src="assets/vendors/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/vendors/jquery-ui/jquery-ui.min.js"></script>
    <script src="assets/vendors/countdown-date-loop-counter/loopcounter.js"></script>
    <script src="assets/js/jquery.counterup.js"></script>
    <script src="assets/vendors/modal-video/jquery-modal-video.min.js"></script>
    <script src="assets/vendors/masonry/masonry.pkgd.min.js"></script>
    <script src="assets/vendors/lightbox/dist/js/lightbox.min.js"></script>
    <script src="assets/vendors/slick/slick.min.js"></script>
    <script src="assets/js/jquery.slicknav.js"></script>
    <script src="assets/js/custom.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script type='text/javascript'>
      $(document).ready(function() {
         let all_flights = []
         let doneTypingInterval = 5000;
         let destinationElement = $("#destination")
         var adults = 1;
         var children = 0;
         var infants = 0;
         var flightClass = "Economy";

         // Set the default value in the input field when the page loads
         $('.togglePassenger').val(adults + ' Adult, ' + children + ' Children, ' + infants + ' Infants, ' + flightClass);
         function updateCount(id, increment, parent) {
            console.log(id)
             var countElement = $(parent).parent().find('.passenger-selector-' + id + '-count');
             var count = parseInt(countElement.text());
             count = increment ? count + 1 : count - 1;
             count = Math.max(0, count); // Ensure the count doesn't go below 0
             if(id === 'adults' && count < 1) count = 1; // Ensure at least 1 adult
             countElement.text(count);

             // Update the stored value
             if (id === 'adults') {
                 adults = count;
                 $("#adults").val(count)
             } else if (id === 'children') {
                 children = count;
                 $("#children").val(count)
             } else if (id === 'infants') {
                 infants = count;
                 $("#infants").val(count)
             }
         }

         $('.passenger-selector-adults-plus').on('click', function () {
             updateCount('adults', true, $(this));
         });
         $('.passenger-selector-adults-minus').on('click', function () {
             updateCount('adults', false, $(this));
         });
         $('.passenger-selector-children-plus').on('click', function () {
             updateCount('children', true, $(this));
         });
         $('.passenger-selector-children-minus').on('click', function () {
             updateCount('children', false, $(this));
         });
         $('.passenger-selector-infants-plus').on('click', function () {
             updateCount('infants', true, $(this));
         });
         $('.passenger-selector-infants-minus').on('click', function () {
             updateCount('infants', false, $(this));
         });

         $('.passenger-selector-class').on('change', function () {
             // Update the stored class value when the dropdown changes
             flightClass = $(this).val();
             console.log(flightClass)
             $("#flightClass").val(flightClass)
         });

         $('.togglePassenger').on('click', function (e) {
             $(this).parent().find('.passenger-selector').toggle();
             e.stopPropagation(); // Prevent click event from bubbling up
         });

         $('.passenger-selector-done-button').on('click', function () {
             // Update the input field with the stored values
             $('.togglePassenger').val(adults + ' Adults, ' + children + ' Children, ' + infants + ' Infants, ' + flightClass);
             $('.passenger-selector').hide();
         });

         $(document).on('click', function (e) {
             if (!$(e.target).closest('.passenger-selector').length && !$(e.target).is('.togglePassenger')) {
               $('.passenger-selector').hide();
             }
         });

         $("#roundtrip-tab").click(function() {
           $("input[name='tripType']").val("ROUND_TRIP")
         })
         $("#oneway-tab").click(function() {
           $("input[name='tripType']").val("ONE_WAY")
         })
         $(".destination,.source").select2({
            selectionCssClass : "input_select",
            minimumInputLength: 3,
            width: "100%",
            ajax: {
               url: 'api.php',
               method: "POST",
               delay: 500,
               data: function(params) {
                  var query = {
                     search_airport: 1,
                     query: params.term
                  }
                  return query
               },
               processResults: function(data) {
                  let response = []
                  for(let d of data.airports) {
                     response.push({ 'text': d.relevantHotelParams.localizedName, 'id': d.relevantFlightParams.skyId, 'place': d.relevantHotelParams.localizedName, 'entity': d.relevantFlightParams.entityId })
                  }
                  return { results: response }
               }
            }
         })

         $(".source").on("change.select2", function(e) {
            let selectedData = $(this).select2('data');
            let nextSourceName = $("#sourceName")
            if (selectedData.length > 0) {
                let originalOption = selectedData[0];
                let place = originalOption.place
                if(place) {
                  $(nextSourceName).val(place)
                }
            }
            let nextSourceEntity = $("#sourceEntity")
            if (selectedData.length > 0) {
                let originalOption = selectedData[0];
                let entity = originalOption.entity
                if(entity) {
                  $(nextSourceEntity).val(entity)
                }
            }
        })

        $(".destination").on("change.select2", function(e) {
            let selectedData = $(this).select2('data');
            let nextDestinationName = $("#destinationName")
            if (selectedData.length > 0) {
                let originalOption = selectedData[0];
                let place = originalOption.place
                if(place) {
                  $(nextDestinationName).val(place)
                }
            }
            let nextDestinationEntity = $("#destinationEntity")
            if (selectedData.length > 0) {
                let originalOption = selectedData[0];
                let entity = originalOption.entity
                if(entity) {
                  $(nextDestinationEntity).val(entity)
                }
            }
        })

         // Function to get query parameters
         function getQueryParam(param) {
            // Get the current URL parameters
            const urlParams = new URLSearchParams(window.location.search);

            // Create a new URLSearchParams to store the cleaned parameters
            const cleanedParams = new URLSearchParams();

            // Iterate through the parameters in reverse order to ensure the last occurrence is kept
            Array.from(urlParams.entries()).reverse().forEach(([key, value]) => {
                // Add to cleanedParams if it's not already added
                if (!cleanedParams.has(key) && value) {
                    cleanedParams.append(key, value);
                }
            });

            // Now the cleanedParams has only non-empty, last occurrence values
            // Recreate the URLSearchParams from cleanedParams in the correct order
            const finalParams = new URLSearchParams(Array.from(cleanedParams.entries()).reverse());

            // Return the requested parameter from finalParams
            return finalParams.get(param);
        }

         function parseDate(dateStr) {
            // Check if date is in valid format MM/DD/YYYY
            const datePattern = /^\d{2}\/\d{2}\/\d{4}$/;
            if (datePattern.test(dateStr)) {
                // Split the date string and reformat to YYYY-MM-DD
                const parts = dateStr.split('/');
                return `${parts[2]}-${parts[0]}-${parts[1]}`;
            } else {
                return null;
            }
        }

        function secondsToHms(d) {
            d = Number(d);
            var h = Math.floor(d / 3600);
            var m = Math.floor(d % 3600 / 60);
            var s = Math.floor(d % 3600 % 60);

            var hDisplay = h > 0 ? h + (h == 1 ? "h " : "h ") : "";
            var mDisplay = m > 0 ? m + (m == 1 ? "m" : "m") : "";
            return hDisplay + mDisplay
         }

         function getFlightById(flightArray, flightId) {
            const flight = flightArray.find(flight => flight.outbound_flight.flight_id === flightId);
            return flight || 'Flight not found';
         }

         function generateFlightDetailsHTML(flightData) {
            var html = `
            <div class="flight-details" style="margin: 0;">
                <div class="card">
                    <div class="card-header">
                        <h3 class="text-white" style="margin: 0;">Flight Details</h3>
                    </div>
                    <div class="card-body">
                        <div class="flight-info">
                            <div class="row">
                                <div class="col-md-12">
                                    <p>
                                        <span class="date-badge" data-date="${flightData.departure_time_full}">
                                            ${moment(flightData.departure_time_full).format('MMMM D, YYYY, h:mm A')}
                                        </span> ・ ${flightData.num_stops} Stop ・ Total Duration: ${flightData.totalTime} ・ Total Layover: ${flightData.formattedLayoverTime}
                                    </p>
                                </div>
                            </div>
                        </div>`;

            flightData.segments.forEach(function(segment) {
                segment.forEach(function(leg, legIndex) {
                    var departure = moment(leg.departure);
                    var arrival = moment(leg.arrival);
                    var duration = moment.duration(arrival.diff(departure));
                    var duration_display = `${duration.hours()}h ${duration.minutes()}m`;

                    html += `
                    <div class="flight-info">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="segment-details">
                                    <img src="${leg.carrier.logoUrl}" alt="${leg.carrier.name} Logo" class="flight-logo">
                                    <div>
                                        <h5>${leg.carrier.name} ${leg.flightNumber}
                                            <span class="date-badge" data-date="${leg.departure}">
                                                ${departure.format('MMMM D, YYYY')}
                                            </span>
                                        </h5>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <p><i class="fas fa-clock"></i>
                                                    <span class="date-spans" data-date="${leg.departure}">
                                                        ${departure.format('h:mm A')}
                                                    </span> - ${leg.origin.displayCode}
                                                </p>
                                                <div class="connector">
                                                    <p class="waypoint">${duration_display}</p>
                                                </div>
                                                <p><i class="fas fa-clock"></i>
                                                    <span class="date-spans" data-date="${leg.arrival}">
                                                        ${arrival.format('h:mm A')}
                                                    </span> - ${leg.destination.displayCode}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>`;

                    if (segment[legIndex + 1]) {
                        var nextDeparture = moment(segment[legIndex + 1].departure);
                        var layoverDuration = moment.duration(nextDeparture.diff(arrival));
                        var layoverTime = `${layoverDuration.hours()}h ${layoverDuration.minutes()}m`;

                        html += `
                                <div class="layover">
                                    <span style="color: black;">
                                        <i class="fas fa-exchange-alt"></i> Layover: ${layoverTime} in ${leg.destination.displayCode}
                                    </span>
                                </div>`;
                    }

                    html += `
                            </div>
                        </div>
                    </div>`;
                });
            });

            html += `
                    </div>
                </div>
            </div>`;

            return html;
        }

        function applyFilters() {
            let priceMin = parseFloat($('#priceMin').val());
            let priceMax = parseFloat($('#priceMax').val());
            let selectedStops = [];
            let selectedAirlines = [];

            // Get selected stop filters
            $('.form-check-input[id^="stop_"]:checked').each(function() {
                selectedStops.push(parseInt($(this).val()));
            });

            // Get selected airline filters
            $('.form-check-input[id^="airline_"]:checked').each(function() {
                selectedAirlines.push($(this).val());
            });

            let flightsFound = false; // Track if any flights match the filters

            // Loop through each flight element
            $('.box-container').each(function() {
                let $flight = $(this);
                let flightType = $flight.data('type'); // 'oneway' or 'roundtrip'
                let matchPrice = false;
                let matchStops = false;
                let matchAirline = false;

                console.log(flightType);

                if (flightType === 'oneway') {
                    let price = parseFloat($flight.find('.price').text().replace('$', '').replace(/,/g, ''));
                    let stops = parseInt($flight.find('.stops').data('stops'));
                    let airline = $flight.find('.airline').text();

                    matchPrice = price >= priceMin && price <= priceMax;
                    matchStops = selectedStops.length === 0 || selectedStops.includes(stops);
                    matchAirline = selectedAirlines.length === 0 || selectedAirlines.includes(airline);
                } else if (flightType === 'roundtrip') {
                    // Handle roundtrip filtering logic
                    let price = parseFloat($flight.find('.price').text().replace('$', '').replace(/,/g, ''));

                    let departureStops = parseInt($flight.find('.departure .stops').data('stops'));
                    let returnStops = parseInt($flight.find('.return .stops').data('stops'));

                    let departureAirline = $flight.find('.departure .airline').text();
                    let returnAirline = $flight.find('.return .airline').text();

                    matchPrice = price >= priceMin && price <= priceMax;
                    matchStops = (selectedStops.length === 0 || selectedStops.includes(departureStops)) ||
                                 (selectedStops.length === 0 || selectedStops.includes(returnStops));
                    matchAirline = (selectedAirlines.length === 0 || selectedAirlines.includes(departureAirline)) ||
                                   (selectedAirlines.length === 0 || selectedAirlines.includes(returnAirline));
                }

                if (matchPrice && matchStops && matchAirline) {
                    $flight.show();
                    flightsFound = true; // At least one flight matches the filters
                } else {
                    $flight.hide();
                }
            });

            if (!flightsFound) {
                // If no flights match, display a "No flights found" message
                if ($('#no-flights-message').length === 0) {
                    $('.flight-list').append('<div id="no-flights-message" class="alert alert-warning">No flights found with the given filters.</div>');
                }
            } else {
                // If flights are found, remove the "No flights found" message if it exists
                $('#no-flights-message').remove();
            }
        }


        function generateFilters(response) {
            const prices = [];
            const airlines = new Set();
            const stops = new Set();

            response.flights.forEach(flight => {
                const price = parseFloat(flight.outbound_flight.price.replace('$', '').replace(/,/g, ''));
                prices.push(price);

                airlines.add(flight.outbound_flight.airline.name);
                stops.add(flight.outbound_flight.stop_count);
            });

            prices.sort((a, b) => a - b);

            const priceFilter = `
                <h3>Filters</h3>
                <div class="filter-section mb-4">
                    <h5 class="filter-title">Price Range</h5>
                    <div class="d-flex align-items-center justify-content-between mb-2">
                        <input type="number" id="priceMin" class="form-control" value="${prices[0]}" min="${prices[0]}" max="${prices[prices.length - 1]}" />
                        <span class="mx-2">to</span>
                        <input type="number" id="priceMax" class="form-control" value="${prices[prices.length - 1]}" min="${prices[0]}" max="${prices[prices.length - 1]}" />
                    </div>
                </div>
            `;

            let stopsFilter = '<div class="filter-section mb-4"><h5 class="filter-title">Stops</h5>';
            stops.forEach(stop => {
                stopsFilter += `
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="${stop}" id="stop_${stop}" />
                        <label class="form-check-label" for="stop_${stop}">
                            ${stop === 0 ? 'Non-stop' : stop + ' Stop' + (stop > 1 ? 's' : '')}
                        </label>
                    </div>
                `;
            });
            stopsFilter += '</div>';

            let airlinesFilter = '<div class="filter-section mb-4"><h5 class="filter-title">Airlines</h5>';
            airlines.forEach(airline => {
                airlinesFilter += `
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="${airline}" id="airline_${airline.replace(/\s/g, '_')}" />
                        <label class="form-check-label" for="airline_${airline.replace(/\s/g, '_')}">
                            ${airline}
                        </label>
                    </div>
                `;
            });
            airlinesFilter += '</div>';

            const filterContainer = $('.col-md-3');
            filterContainer.empty();
            filterContainer.append(priceFilter);
            filterContainer.append(stopsFilter);
            filterContainer.append(airlinesFilter);
            $(document).on('change', '.form-check-input', applyFilters);
            $(document).on('input', '#priceMin', applyFilters);
            $(document).on('input', '#priceMax', applyFilters);
        }

        function extractFlightData(flight) {
           // Prepare variables for looping
           const legs = flight.legs || [];
           let totalDuration = 0;
           let totalLayoverTime = 0;
           let segments = [];
           let from_airport = '';
           let from_airport_code = '';
           let to_airport = '';
           let to_airport_code = '';
           let departure_time_full = '';
           let num_stops = 0;

           // Loop through legs to calculate total duration and layovers
           legs.forEach((leg, index) => {
               const origin = leg.origin.name || '';
               const originCode = leg.origin.displayCode || '';
               const destination = leg.destination.name || '';
               const destinationCode = leg.destination.displayCode || '';
               const departure = leg.departure || '';
               const arrival = leg.arrival || '';
               const durationInMinutes = leg.durationInMinutes || 0;
               const carrier = leg.carriers.marketing[0] || {};

               // Push segment details
               segments.push(leg.segments.map(segment => ({
                   carrier: {
                       name: carrier.name || '',
                       logoUrl: carrier.logoUrl || '',
                   },
                   flightNumber: segment.flightNumber || '',
                   departure: segment.departure || '',
                   arrival: segment.arrival || '',
                   origin: {
                       displayCode: segment.origin.displayCode || '',
                   },
                   destination: {
                       displayCode: segment.destination.displayCode || '',
                   },
               })));

               // Set initial airport details for the first leg
               if (index === 0) {
                   from_airport = origin;
                   from_airport_code = originCode;
                   departure_time_full = departure;
               }

               // Set final destination airport details for the last leg
               if (index === legs.length - 1) {
                   to_airport = destination;
                   to_airport_code = destinationCode;
               }

               // Calculate total duration
               totalDuration += durationInMinutes;

               // Calculate layover time (if applicable)
               leg.segments.forEach((segment, segIndex) => {
                   const currentArrival = segment.arrival;
                   if (leg.segments[segIndex + 1]) {
                       const nextSegment = leg.segments[segIndex + 1];
                       const currentDeparture = nextSegment.departure;
                       const departureTime = new Date(currentDeparture);
                       const previousArrivalTime = new Date(currentArrival);
                       const layoverInterval = (departureTime - previousArrivalTime) / 60000; // difference in minutes
                       totalLayoverTime += layoverInterval;
                       num_stops++;
                   }
               });
           });

           // Format total duration for display
           const totalHours = Math.floor(totalDuration / 60);
           const totalMinutes = totalDuration % 60;
           const totalTime = `${totalHours}h ${totalMinutes}m`;

           // Format total layover time for display
           const totalLayoverHours = Math.floor(totalLayoverTime / 60);
           const totalLayoverMinutes = totalLayoverTime % 60;
           const formattedLayoverTime = `${totalLayoverHours}h ${totalLayoverMinutes}m`;

           return {
               from_airport,
               from_airport_code,
               to_airport,
               to_airport_code,
               departure_time_full,
               num_stops,
               totalTime,
               formattedLayoverTime,
               segments
           };
        }


         // Get query parameters
         const sourceAirportCode = getQueryParam('sourceAirportCode');
         const sourceAirportName = getQueryParam('sourceAirportName');
         const sourceAirportEntity = getQueryParam('sourceEntity');
         const destinationAirportCode = getQueryParam('destinationAirportCode');
         const destinationAirportName = getQueryParam('destinationAirportName');
         const destinationAirportEntity = getQueryParam('destinationEntity');
         const adultsParam = getQueryParam('adults') || 1;
         const childrensParam = getQueryParam('childrens') || 0;
         const infantsParam = getQueryParam('infants') || 0;
         const flightClassParam = getQueryParam('flight_class') || "economy";
         const dateStr = getQueryParam('date');
         const returnDateStr = getQueryParam('returnDate');
         const tripType = getQueryParam('tripType');
         const date = parseDate(dateStr);
         const returnDate = parseDate(returnDateStr);

         console.log("here", flightClass)

         // Check if all required parameters are present
         if (sourceAirportCode && destinationAirportCode && adults && date) {
              let formattedClass = "Economy"
              if(flightClass == "economy") {
                formattedClass = "Economy"
              }
              if(flightClass == "premium_economy") {
                formattedClass = "Economy"
              }
              if(flightClass == "business") {
                formattedClass = "Business"
              }
              if(flightClass == "first") {
                formattedClass = "First"
              }
               $("#sourceAirportName").text(sourceAirportName)
               $("#sourceAirportCode").text(sourceAirportCode)
               $("#destinationAirportName").text(destinationAirportName)
               $("#destinationAirportCode").text(destinationAirportCode)
               $("#departDate").text(date)
               $("#returnDateModal").text((returnDate) ? returnDate : "-")
               $("#paxNo").text(parseInt(adultsParam) + parseInt(childrensParam) + parseInt(infantsParam))
               $("#selectedClass").text(formattedClass)
               $("#aero_loader").show()
               const data = {
                  originSkyId: sourceAirportCode,
                  originEntityId: sourceAirportEntity,
                  sourceAirportName: sourceAirportName,
                  destinationSkyId: destinationAirportCode,
                  destinationEntityId: destinationAirportEntity,
                  destinationAirportName: destinationAirportName,
                  adults: adultsParam,
                  childrens: childrensParam,
                  infants: infantsParam,
                  cabinClass: flightClassParam,
                  date: date,
                  tripType: tripType,
                  returnDate: returnDate,
                  search_flights: 1
               }

               // Send data to the new POST API
               $.ajax({
                  url: 'api.php',
                  type: 'POST',
                  data: data,
                  success: function(response) {
                     $("#aero_loader").hide()
                     if(response.error || response.flights.length == 0) {
                        $("#flights").text("No flights found.")
                        $("#flightResult").text("0")
                        return
                     }
                     all_flights = response.flights
                     let flightNo = 0
                     generateFilters(response);
                     for(let flight of response.flights) {
                        let first_flight = flight.outbound_flight
                        let duration = moment.duration(first_flight.duration_in_minutes, 'minutes');
                        let duration_hours = Math.floor(duration.asHours());
                        let duration_mins = duration.minutes();
                        first_flight.total_time = `${duration_hours}h ${duration_mins}m`
                        first_flight.stops = ""
                        if(first_flight.stop_count == 0) {
                           first_flight.stops = "Non-Stop"
                        }
                        else {
                           if(first_flight.stop_count == 1) {
                              first_flight.stops = "1 Stop"
                           }
                           else {
                              first_flight.stops = `${first_flight.stop_count} Stops`
                           }
                        }
                        let returnData = {}
                        let returnAvailable = false
                        if(flight.return_flight) {
                          returnAvailable = true
                          returnData = flight.return_flight
                          let duration = moment.duration(returnData.duration_in_minutes, 'minutes');
                          let duration_hours = Math.floor(duration.asHours());
                          let duration_mins = duration.minutes();
                          returnData.total_time = `${duration_hours}h ${duration_mins}m`
                          returnData.stops = ""
                          if(returnData.stop_count == 0) {
                             returnData.stops = "Non-Stop"
                          }
                          else {
                             if(returnData.stop_count == 1) {
                                returnData.stops = "1 Stop"
                             }
                             else {
                                returnData.stops = `${returnData.stop_count} Stops`
                             }
                          }
                        }
                        let firstFlightlogoUrl = first_flight.airline.logo_url.replace("favicon", "small")
                        let returnFlightLogoUrl = (returnAvailable) ? returnData.airline.logo_url.replace("favicon", "small") : ""
                        if (!returnAvailable) {
                          let flightData = extractFlightData(flight.flight)
                          let segments = flightData.segments
                          let flightDetailsHtml = generateFlightDetailsHTML(flightData)
                          let html = `<div class="box-container" data-type="oneway">
                            <div class="global-container">
                              <div class="container-70">
                                  <p><strong>Departure:</strong></p>
                                  <div class="flight-card d-flex flex-row align-items-center" style="">
                                    <img src="${firstFlightlogoUrl}" alt="Flight Image" class="flight-img" />
                                    <div class="airline" style="display: none;">${first_flight.airline.name}</div>
                                    <div class="flight-info d-flex flex-column flex-grow-1">
                                      <div class="d-flex justify-content-between align-items-center flight-times">
                                        <div class="flight-time">
                                          <span class="airport from_airport" data-code="${first_flight.from_airport.airport_code}">${first_flight.from_airport.city}</span>
                                          <span class="time from_airport_time">${moment(first_flight.departure_time).format("hh:mm A")}</span>
                                        </div>
                                        <div class="flight-details d-flex flex-column align-items-center">
                                          <span class="total-time">${first_flight.total_time}</span>
                                          <span class="line"></span>
                                          <span class="stops" data-stops="${first_flight.stop_count}">${first_flight.stops}</span>
                                        </div>
                                        <div class="flight-time text-right">
                                          <span class="airport to_airport" data-code="${first_flight.to_airport.airport_code}">${first_flight.to_airport.city}</span>
                                          <span class="time to_airport_time">${moment(first_flight.arrival_time).format("hh:mm A")}</span>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="collapse" id="flightDetails${flightNo}">
                                    ${flightDetailsHtml}
                                  </div>
                                </div>
                                <div class="vertical-hr"></div>
                                <div class="container-30">
                                  <p style="margin: 0;"><strong class="price">${first_flight.price}</strong></p>
                                  <button class="" type="button" data-toggle="collapse" data-target="#flightDetails${flightNo}" aria-expanded="false" aria-controls="flightDetails${flightNo}">More Details</button><br>
                                  <button class="btn btn-primary d-md-block book_now_button" data-flight_id="${first_flight.flight_id}">Book Now</button>
                                </div>
                              </div>
                            </div>`
                          $("#flights").append(html)
                          flightNo++
                        }
                        else {
                          let flightData = extractFlightData(flight.flight)
                          let segments = flightData.segments
                          let flightDetailsHtml = generateFlightDetailsHTML(flightData)
                          let total_price = flight.total_price
                          let html = `<div class="box-container" data-type="roundtrip">
                            <div class="global-container">
                              <div class="container-70">
                                  <p><strong>Departure:</strong></p>
                                  <div class="flight-card d-flex flex-row align-items-center departure" style="">
                                    <img src="${firstFlightlogoUrl}" alt="Flight Image" class="flight-img" />
                                    <div class="airline" style="display: none;">${first_flight.airline.name}</div>
                                    <div class="flight-info d-flex flex-column flex-grow-1">
                                      <div class="d-flex justify-content-between align-items-center flight-times">
                                        <div class="flight-time">
                                          <span class="airport from_airport" data-code="${first_flight.from_airport.airport_code}">${first_flight.from_airport.city}</span>
                                          <span class="time from_airport_time">${moment(first_flight.departure_time).format("hh:mm A")}</span>
                                        </div>
                                        <div class="flight-details d-flex flex-column align-items-center">
                                          <span class="total-time">${first_flight.total_time}</span>
                                          <span class="line"></span>
                                          <span class="stops" data-stops="${first_flight.stop_count}">${first_flight.stops}</span>
                                        </div>
                                        <div class="flight-time text-right">
                                          <span class="airport to_airport" data-code="${first_flight.to_airport.airport_code}">${first_flight.to_airport.city}</span>
                                          <span class="time to_airport_time">${moment(first_flight.arrival_time).format("hh:mm A")}</span>
                                        </div>
                                      </div>
                                    </div>
                                  </div>

                                  <p><strong>Return:</strong></p>
                                  <div class="flight-card d-flex flex-row align-items-center return" style="">
                                    <img src="${returnFlightLogoUrl}" alt="Flight Image" class="flight-img" />
                                    <div class="airline" style="display: none;">${returnData.airline.name}</div>
                                    <div class="flight-info d-flex flex-column flex-grow-1">
                                      <div class="d-flex justify-content-between align-items-center flight-times">
                                        <div class="flight-time">
                                          <span class="airport from_airport" data-code="${returnData.from_airport.airport_code}">${returnData.from_airport.city}</span>
                                          <span class="time from_airport_time">${moment(returnData.departure_time).format("hh:mm A")}</span>
                                        </div>
                                        <div class="flight-details d-flex flex-column align-items-center">
                                          <span class="total-time">${returnData.total_time}</span>
                                          <span class="line"></span>
                                          <span class="stops" data-stops="${returnData.stop_count}">${returnData.stops}</span>
                                        </div>
                                        <div class="flight-time text-right">
                                          <span class="airport to_airport" data-code="${returnData.to_airport.airport_code}">${returnData.to_airport.city}</span>
                                          <span class="time to_airport_time">${moment(returnData.arrival_time).format("hh:mm A")}</span>
                                        </div>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="collapse" id="flightDetails${flightNo}">
                                    ${flightDetailsHtml}
                                  </div>
                                </div>

                              <div class="vertical-hr"></div>
                              <div class="container-30">
                                <p style="margin: 0;"><strong class="price">${total_price}</strong></p>
                                <button class="btn btn-link toggle-details" type="button" data-toggle="collapse" data-target="#flightDetails${flightNo}" aria-expanded="false" aria-controls="flightDetails${flightNo}">More Details</button>
                                <button class="btn btn-primary d-md-block book_now_button" data-flight_id="${first_flight.flight_id}">Book Now</button>
                              </div>
                            </div>
                          </div>`
                          $("#flights").append(html)
                          flightNo++
                        }
                     }
                     $('html, body').animate({
                      scrollTop: $('.flight-list').offset().top
                     }, 1000);

                     $(document).on("click", 'button.book_now_button', function(e) {
                        e.stopImmediatePropagation()
                        let flightId = $(this).data("flight_id")
                        let flight = getFlightById(all_flights , flightId)
                        console.log(flight)
                        let form = $('<form>', {
                           action: 'booking.php',
                           method: 'post'
                        })

                        function addInputs(obj, parentKey = '') {
                           Object.keys(obj).forEach(key => {
                              let value = obj[key];
                              let name = parentKey ? `${parentKey}[${key}]` : key;

                              if (typeof value === 'object' && value !== null) {
                                    addInputs(value, name);
                              } else {
                                    $('<input>').attr({
                                       type: 'hidden',
                                       name: name,
                                       value: value
                                    }).appendTo(form);
                              }
                           });
                        }

                        addInputs(flight.flight)
                        $('<input>').attr({ type: 'hidden', name: "adults", value: adultsParam }).appendTo(form)
                        $('<input>').attr({ type: 'hidden', name: "childrens", value: childrensParam }).appendTo(form)
                        $('<input>').attr({ type: 'hidden', name: "infants", value: infantsParam }).appendTo(form)
                        $('<input>').attr({ type: 'hidden', name: "flight_class", value: flightClassParam }).appendTo(form)
                        $('<input>').attr({ type: 'hidden', name: "submit_booking", value: "1" }).appendTo(form)
                        form.appendTo('body').submit()

                     })
                     let flightAvailable = response.length;

                     $("#flightResult").text(flightAvailable)
                  },
                  error: function(error) {
                     console.error('Error sending data:', error);
                  }
               });
         } else {
            $("#flights").text("No flights found.")
            $("#flightResult").text("0")
         }
      });
</script>
  </body>
</html>
