<?php
if(isset($_POST["booking_confirmation"])) {
    $data = $_POST;
    $bookingId = $_POST['id'] ?? '';
    $pnr = $bookingId;
    $bookingRef = uniqid();
    $pnr = uniqid();
    $bookingDate = date('Y-m-d');
    $priceRaw = $_POST['price']['raw'] ?? 0;
    $priceFormatted = $_POST['price']['formatted'] ?? '';
    $pricingOptionId = $_POST['price']['pricingOptionId'] ?? '';

    $adults = $_POST['adults'] ?? 0;
    $children = $_POST['childrens'] ?? 0;
    $infants = $_POST['infants'] ?? 0;
    $totalPassengers = $adults + $children;
    $pricePerPerson = $totalPassengers > 0 ? $priceRaw / $totalPassengers : 0;
<f
    $totalAdultPrice = number_format($pricePerPerson * $adults, 2);
    $totalChildrenPrice = number_format($pricePerPerson * $children, 2);
    $totalInfantPrice = 0; // Infants travel free or have no charge
    $pricePerPerson = number_format($pricePerPerson, 2);

    // Prepare variables for looping
    $legs = $_POST['legs'] ?? [];
    $totalDuration = 0;
    $totalLayoverTime = 0;
    $segments = [];
    $from_airport = '';
    $from_airport_code = '';
    $to_airport = '';
    $to_airport_code = '';
    $departure_time_full = '';
    $num_stops = 0;

    // Loop through legs to calculate total duration and layovers
    foreach ($legs as $index => $leg) {
        $origin = $leg['origin']['name'] ?? '';
        $originCode = $leg['origin']['displayCode'] ?? '';
        $destination = $leg['destination']['name'] ?? '';
        $destinationCode = $leg['destination']['displayCode'] ?? '';
        $departure = $leg['departure'] ?? '';
        $arrival = $leg['arrival'] ?? '';
        $durationInMinutes = $leg['durationInMinutes'] ?? 0;
        $carriers = $leg['carriers']['marketing'][0] ?? [];
        $segments[] = $leg['segments'] ?? [];

        // Set initial airport details for the first leg
        if ($index === 0) {
            $from_airport = $origin;
            $from_airport_code = $originCode;
            $departure_time_full = $departure;
        }

        // Set final destination airport details for the last leg
        if ($index === count($legs) - 1) {
            $to_airport = $destination;
            $to_airport_code = $destinationCode;
        }

        // Calculate total duration
        $totalDuration += $durationInMinutes;

        // Calculate layover time (if applicable)
        foreach($leg['segments'] as $index => $segment) {
          $currentArrival = $segment["arrival"];
          if(!empty($leg['segments'][$index + 1])) {
              $nextSegment = $leg['segments'][$index + 1];
              $currentDeparture = $nextSegment["departure"];
              $departureTime = new DateTime($currentDeparture);
              $previousArrivalTime = new DateTime($currentArrival);
              $layoverInterval = $previousArrivalTime->diff($departureTime);
              $layoverHours = $layoverInterval->h;
              $layoverMinutes = $layoverInterval->i;
              $layoverTime = "{$layoverHours}h {$layoverMinutes}m";
              $totalLayoverTime += ($layoverHours * 60) + $layoverMinutes;
              $num_stops++;
            }
        }

        // Store the arrival time to calculate the next layover
        $previousArrival = $arrival;
    }

    // Format total duration for display
    $totalHours = floor($totalDuration / 60);
    $totalMinutes = $totalDuration % 60;
    $totalTime = "{$totalHours}h {$totalMinutes}m";

    // Format total layover time for display
    $totalLayoverHours = floor($totalLayoverTime / 60);
    $totalLayoverMinutes = $totalLayoverTime % 60;
    $formattedLayoverTime = "{$totalLayoverHours}h {$totalLayoverMinutes}m";

    // Prepare the final output data
    $all_data = [
      'segments' => $segments,
      'totalTime' => $totalTime,
      'totalLayoverTime' => $formattedLayoverTime,
      'num_stops' => $num_stops,
    ];

    $emailHtmlContent = "
    <!DOCTYPE html>
    <html lang='en'>
    <head>
        <meta charset='UTF-8'>
        <meta name='viewport' content='width=device-width, initial-scale=1.0'>
        <title>Booking Confirmation</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 0;
                background-color: #f4f4f4;
            }
            .container {
                width: 100%;
                padding: 20px;
                background-color: #fff;
                max-width: 600px;
                margin: 20px auto;
                border-radius: 8px;
                box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            }
            .header {
                background-color: #007bff;
                color: white;
                padding: 20px;
                text-align: center;
                border-radius: 8px 8px 0 0;
            }
            .content {
                padding: 20px;
            }
            .footer {
                text-align: center;
                padding: 10px;
                font-size: 12px;
                color: #666;
            }
            .flight-info, .passenger-info, .contact-info, .important-info {
                margin-bottom: 20px;
            }
            .flight-info h3, .passenger-info h3, .contact-info h3, .important-info h3 {
                background-color: #f56960;
                color: white;
                padding: 10px;
                border-radius: 4px;
            }
            .info-table {
                width: 100%;
                border-collapse: collapse;
                margin-top: 10px;
            }
            .info-table th, .info-table td {
                padding: 10px;
                border: 1px solid #ddd;
            }
            .info-table th {
                background-color: #f4f4f4;
                text-align: left;
            }
            .layover {
                background-color: #e9ecef;
                padding: 10px;
                margin-top: 10px;
                text-align: center;
                border-radius: 4px;
            }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>Booking Confirmation</h1>
                <p>Booking Reference: {$bookingRef}</p>
                <p>Status: In process</p>
                <p>PNR: {$pnr}</p>
                <p>Booking Date: {$bookingDate}</p>
            </div>
            <div class='content'>
                <div class='flight-info'>
                    <h3>Flight Details</h3>
                    <p><strong>Departure Date:</strong> " . date('F j, Y, g:i A', strtotime($departure_time_full)) . "</p>
                    <p><strong>Total Duration:</strong> {$totalTime}</p>
                    <p><strong>Total Layover Time:</strong> {$formattedLayoverTime}</p>
                    <p><strong>Number of Stops:</strong> {$num_stops}</p>

                    <!-- Flight Segments -->
                    ";
                    foreach ($segments as $segmentIndex => $segment) {
                        foreach ($segment as $legIndex => $leg) {
                            $departure = new DateTime($leg['departure']);
                            $arrival = new DateTime($leg['arrival']);
                            $duration = $departure->diff($arrival);
                            $duration_display = $duration->h . "h " . $duration->i . "m";

                            $emailHtmlContent .= "
                            <div>
                                <p><strong>{$carriers['name']} {$leg['flightNumber']}:</strong> {$departure->format('g:i A')} - {$leg['origin']['displayCode']} to {$leg['destination']['displayCode']} ({$duration_display})</p>
                            ";
                            if (isset($segment[$legIndex + 1])) {
                                $nextDeparture = new DateTime($segment[$legIndex + 1]['departure']);
                                $layoverInterval = $arrival->diff($nextDeparture);
                                $layoverTime = $layoverInterval->h . "h " . $layoverInterval->i . "m";
                                $emailHtmlContent .= "
                                <div class='layover'>
                                    Layover: {$layoverTime} in {$leg['destination']['displayCode']}
                                </div>";
                            }
                            $emailHtmlContent .= "
                            </div>";
                        }
                    }

    $emailHtmlContent .= "
                </div>

                <div class='passenger-info'>
                    <h3>Passenger Details</h3>
                    <table class='info-table'>
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Gender</th>
                                <th>Date of Birth</th>
                            </tr>
                        </thead>
                        <tbody>";
                        for ($i = 1; $i <= $data['total_passengers']; $i++) {
                            $emailHtmlContent .= "
                            <tr>
                                <td>{$data['title-' . $i]} {$data['firstname-' . $i]} {$data['lastname-' . $i]}</td>
                                <td>{$data['gender-' . $i]}</td>
                                <td>{$data['dob-' . $i]}</td>
                            </tr>";
                        }

    $emailHtmlContent .= "
                        </tbody>
                    </table>
                </div>

                <div class='contact-info'>
                    <h3>Contact Details</h3>
                    <table class='info-table'>
                        <tr>
                            <th>Name</th>
                            <td>{$data['t-firstname']} {$data['t-lastname']}</td>
                        </tr>
                        <tr>
                            <th>Email</th>
                            <td>{$data['t-email']}</td>
                        </tr>
                        <tr>
                            <th>Mobile</th>
                            <td>{$data['t-mobile']}</td>
                        </tr>
                    </table>
                </div>

                <div class='important-info'>
                    <h3>Important Information</h3>
                    <ul>
                        <li>Please check the flight information.</li>
                        <li>All Tickets are Non-refundable, Non-changeable and Non-transferable unless otherwise specified.</li>
                        <li>This trip is priced with a fare which is limited in availability and cannot be guaranteed unless paid and a ticket issued from the airline inventory. Any change (if any) will be informed before further processing.</li>
                        <li>Traveling with children: Please note children under the age of 2 years on the date of travel do not have a separate seat and are required to sit in the accompanying adult's lap.</li>
                        <li>Special Assistance: Requests for special assistance, preferred meals, and frequent flyer credit will be registered with the airline; however, this is on a request basis only.</li>
                        <li>Baggage: Please check your baggage allowance (printed in E-ticket) prior to arrival at the airport.</li>
                        <li>Visa and health regulations: Ensure you are fully aware of any visa, health, or other country-specific information which may relate to your destination.</li>
                        <li>Always check your flight timings with airlines at least 72 hrs before departure.</li>
                    </ul>
                </div>
            </div>
            <div class='footer'>
                <p>Airfare Service Hub LLC | 20178-001 IFZA Business Park, DDP, Silicon Oasis, Dubai, United Arab Emirates | +971-55-873-2462</p>
            </div>
        </div>
    </body>
    </html>";
}
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- favicon -->
    <link rel="icon" type="image/png" href="assets/images/skyloo.png">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="assets/vendors/bootstrap/css/bootstrap.min.css" media="all">
    <link rel="stylesheet" href="assets/css/style.css">
    <!-- Fonts Awesome CSS -->
    <link rel="stylesheet" type="text/css" href="assets/vendors/fontawesome/css/all.min.css">
    <!-- jquery-ui css -->
    <link rel="stylesheet" type="text/css" href="assets/vendors/jquery-ui/jquery-ui.min.css">
    <!-- modal video css -->
    <link rel="stylesheet" type="text/css" href="assets/vendors/modal-video/modal-video.min.css">
    <!-- light box css -->
    <link rel="stylesheet" type="text/css" href="assets/vendors/lightbox/dist/css/lightbox.min.css">
    <!-- slick slider css -->
    <link rel="stylesheet" type="text/css" href="assets/vendors/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="assets/vendors/slick/slick-theme.css">
    <!-- google fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,400&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,400&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer">
    <!-- Custom CSS -->
    <link rel="stylesheet" type="text/css" href="style.css">
    <link rel="stylesheet" type="text/css" href="assets/css/booking.css">
    <title translate="no">Viajerosbaratos</title>
    <style>
    .flight-logo {
      width: 30px;
      height: auto;
    }
    .card-header {
      background-color: #F56960;
      color: #fff;
    }
    .date-badge {
      background-color: #ffedd1;
      padding: 5px;
      border-radius: 5px;
      color: black;
    }
    .flight-info {
      background-color: #f8f9fa;
      padding: 15px;
      border-radius: 10px;
      margin-bottom: 15px;
    }
    .segment-details {
      display: flex;
      align-items: center;
      margin-bottom: 10px;
      flex-wrap: wrap;
    }
    .segment-details img {
      margin-right: 10px;
    }
    .connector {
      position: relative;
      margin-left: 20px;
    }
    .connector::before {
      content: '';
      position: absolute;
      left: -10px;
      top: 0;
      bottom: 0;
      width: 2px;
      background-color: #007bff;
    }
    .waypoint {
      color: #007bff;
    }
    .layover {
      background-color: #e9ecef;
      padding: 10px;
      border-radius: 10px;
      margin-top: 10px;
      margin-bottom: 10px;
      text-align: center;
      width: 100%;
    }
    span {
        color: black;
    }
    select {
        border: 1px solid #d9d9d9 !important;
        height: 48px !important;
    }
    table thead tr {
        background-color: white;
    }
    select.is-invalid {
        border-color: #dc3545 !important;
        border-top-color: rgb(220, 53, 69);
        border-right-color: rgb(220, 53, 69);
        border-bottom-color: rgb(220, 53, 69);
        border-left-color: rgb(220, 53, 69);
        padding-right: calc(1.5em + .75rem);
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' stroke='%23dc3545' viewBox='0 0 12 12'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right calc(.375em + .1875rem) center;
        background-size: calc(.75em + .375rem) calc(.75em + .375rem);
    }
    @media (max-width: 576px) {
      .segment-details {
        flex-direction: column;
        align-items: flex-start;
      }
      .connector::before {
        left: -20px;
      }
      .date-badge {
        font-size: 0.8rem;
        padding: 3px;
      }
      .layover {
        margin-top: 20px;
      }
    }
  </style>
  </head>
  <body class="home">
    <div id="siteLoader" class="site-loader">
      <div class="preloader-content">
        <img src="assets/images/loader1.gif" alt="" />
      </div>
    </div>
    <div id="page" class="full-page">
      <!-- header-area -->
        <header>
            <div class="header-top">
                <div class="container custom-container">
                    <div class="row">
                        <div class="col-xl-4">
                            <div class="header-top-left">
                                                            </div>
                        </div>
                        <div class="col-xl-8">
                            <div class="header-top-right">
                                <ul>
                                                                         <li><a href="tel:+971-55-873-2462"><i class="fas fa-mobile-alt"></i>+971-55-873-2462</a></li>
                                                                                                           
                                                                    </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="sticky-header" class="menu-area transparent-header">
                <div class="container custom-container">
                    <div class="row">
                        <div class="col-12 mobile">
                            <div class="mobile-nav-toggler"><span class="sign"><i class="fa-regular"></i></span> <i class="fas fa-bars"></i></div>
                            <div class="menu-wrap">
                                <nav class="menu-nav">
                                    <div class="logo"><a class="head" href="/"><img src="assets/images/viajerosbaratos.png" alt="logo" width="200" height="36"></a>
                                      <a class="scrol" href="/"><img src="assets/images/viajerosbaratos.png" alt="logo" width="200" height="36"></a></div>
                                    <div class="navbar-wrap main-menu d-none d-lg-flex">
                                        <ul class="navigation">
                                            <li><a href="/">Hogar</a></li>
                                            <li><a href="about-us.php">Sobre nosotras</a></li>
                                            <li><a href="privacy-policy">Política de privacidad</a></li>
                                            <li><a href="contact.php">Contacta</a></li>

                                        </ul>
                                    </div>
                                    <div class="header-action d-none d-md-block">
                                                                                 <ul>
                                            <li class="header-btn"><a href="tel:+971-55-873-2462" class="btn"><i class="fa-solid fa-phone-volume blink"></i>+971-55-873-2462</a></li>
                                        </ul>
                                                                             </div>
                                </nav>
                            </div>
                            <!-- Mobile Menu  -->
                            <div class="mobile-menu">
                                <nav class="menu-box">
                                    <div class="close-btn"><i class="fa-solid fa-xmark"></i></div>
                                    <div class="nav-logo"><a href="/"><img src="assets/images/viajerosbaratos.png" alt="logo"></a>
                                    </div>
                                    <div class="menu-outer">
                                        <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                                    </div>
                                    <!-- <div class="social-links">
                                        <ul class="clearfix">
                                            <li><a href="#"><span class="fab fa-twitter"></span></a></li>
                                            <li><a href="#"><span class="fab fa-facebook-f"></span></a></li>
                                            <li><a href="#"><span class="fab fa-pinterest-p"></span></a></li>
                                            <li><a href="#"><span class="fab fa-instagram"></span></a></li>
                                            <li><a href="#"><span class="fab fa-youtube"></span></a></li>
                                        </ul>
                                    </div> -->
                                </nav>
                            </div>
                            <div class="menu-backdrop"></div>
                            <!-- End Mobile Menu -->
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <!-- header-area-end -->
      <main id="content" class="site-main">
        <!-- Inner Banner html start-->
        <section class="inner-banner-wrap">
          <div class="inner-baner-container" style="background-image: url(assets/images/policy.jpg);">
            <div class="container">
              <div class="inner-banner-content">
                <h1 class="inner-title">Confirmación de reserva</h1>
              </div>
            </div>
          </div>
        </section>
        <div class="container mt-5">
            <div class="card mb-3">
                <div class="card-body">
                    <h5 class="card-title">Referencia de reserva: <?= $bookingRef; ?></h5>
                    <p class="card-text">Estado: En proceso</p>
                    <p class="card-text">PNR: <?= $pnr; ?></p>
                    <p class="card-text">Fecha de reserva: <?= $bookingDate; ?></p>
                </div>
            </div>

           

            <div class="card mb-3">
                <div class="card-body">
                  <div class="col-lg-12 box-center" style="padding: 0px !important;">
                    <div class="container flight-details">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="text-white" style="margin: 0;">Detalles del vuelo</h3>
                            </div>
                            <div class="card-body">
                                <div class="flight-info">
                                    <div class="row">
                                        <div class="col-md-12">
                                          <p><span class="date-badge" data-date="<?= $departure_time_full; ?>"><?php echo date('F j, Y, g:i A', strtotime($departure_time_full)); ?></span> ・ <?php echo $num_stops; ?> Stop ・ Total Duration: <?php echo $totalTime; ?> ・ Total Layover: <?php echo $formattedLayoverTime; ?></p>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                foreach ($segments as $segmentIndex => $segment) {
                                    foreach ($segment as $legIndex => $leg) {
                                        $departure = new DateTime($leg["departure"]);
                                        $arrival = new DateTime($leg["arrival"]);
                                        $duration = $departure->diff($arrival);
                                        $duration_display = $duration->h . "h " . $duration->i . "m";

                                        // Display the flight segment
                                        ?>
                                        <div class="flight-info">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="segment-details">
                                                        <img src="<?php echo $carriers["logoUrl"]; ?>" alt="<?php echo $carriers["name"]; ?> Logo" class="flight-logo">
                                                        <div>
                                                            <h5><?php echo $carriers["name"] . " " . $leg["flightNumber"]; ?> <span class="date-badge" data-date="<?= $leg["departure"]; ?>"><?php echo $departure->format('F j, Y'); ?></span></h5>
                                                            <div class="row">
                                                                <div class="col-md-12">
                                                                    <p><i class="fas fa-clock"></i> <span class="date-spans" data-date="<?= $leg["departure"]; ?>"><?php echo $departure->format('g:i A'); ?></span> - <?php echo $leg["origin"]["displayCode"]; ?></p>
                                                                    <div class="connector">
                                                                        <p class="waypoint"><?php echo $duration_display; ?></p>
                                                                    </div>
                                                                    <p><i class="fas fa-clock"></i> <span class="date-spans" data-date="<?= $leg["arrival"]; ?>"><?php echo $arrival->format('g:i A'); ?></span> - <?php echo $leg["destination"]["displayCode"]; ?></p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php
                                                    // Calculate and display the layover for the next segment
                                                    if (isset($segment[$legIndex + 1])) {
                                                        $nextDeparture = new DateTime($segment[$legIndex + 1]["departure"]);
                                                        $layoverInterval = $arrival->diff($nextDeparture);
                                                        $layoverHours = $layoverInterval->h;
                                                        $layoverMinutes = $layoverInterval->i;
                                                        $layoverTime = "{$layoverHours}h {$layoverMinutes}m";
                                                        ?>
                                                        <div class="layover">
                                                            <span style="color: black;"><i class="fas fa-exchange-alt"></i> Layover: <?php echo $layoverTime; ?> in <?php echo $leg["destination"]["displayCode"]; ?></span>
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                  </div>
                </div>
            </div>

            <div class="card mb-3">
                <div class="card-body">
                    <h5 class="card-title">Resumen de tarifas</h5>
                    <div class="col-lg-12 box-right">
                        <p style="margin: 0;"><?= $adults; ?> Adultas</p>
                        <p style="margin: 0;"><?= $children; ?> Niñas</p>
                        <p style="margin: 0;"><?= $infants; ?> Bebés</p>
                        <hr />
                        <div class="form-check pl-0">
                            <label class="form-check-label" for="nonstop">
                                <span class="float-start fare-text"><strong>Tarifa base</strong></span> <span class="float-end fare-text"><strong><?= $priceFormatted; ?></strong></span>
                            </label>
                            <label class="form-check-label" for="nonstop"><span class="float-start fare-text">Adulta (<?= $adults; ?> × $<?= $pricePerPerson; ?>)</span> <span class="float-end fare-text">$<?= $totalAdultPrice; ?></span></label>
                            <label class="form-check-label" for="nonstop"><span class="float-start fare-text">Niñas (<?= $children; ?> × $<?= $pricePerPerson; ?>)</span> <span class="float-end fare-text">$<?= $totalChildrenPrice; ?></span></label>
                            <label class="form-check-label" for="nonstop"><span class="float-start fare-text">Bebés (<?= $infants; ?> × $0)</span> <span class="float-end fare-text">$<?= $totalInfantPrice; ?></span></label>
                        </div>
                        <hr />
                        <hr />
                        <div class="form-check pl-0">
                            <label class="form-check-label" for="nonstop">
                                <span class="float-start fare-text"><strong>Impuestos y Honorarios</strong></span> <span class="float-end fare-text"><strong>$0</strong></span>
                            </label>
                            <label class="form-check-label" for="nonstop"><span class="float-start fare-text">Adulta (1 × <?= $totalPassengers; ?>)</span> <span class="float-end fare-text">$0</span></label>
                        </div>
                        <div class="form-check pl-0">
                            <label class="form-check-label" for="onestop">
                                <span class="float-start fare-total"><strong>Precio total:</strong></span> <span class="float-end fare-total"><strong><?= $priceFormatted; ?></strong></span>
                            </label>
                        </div>
                        <hr />
                    </div>
                </div>
            </div>

            <div class="card mb-3">
                <div class="card-body">
                    <h5 class="card-title">Detalles del pasajero</h5>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Nombre</th>
                                    <th>Género</th>
                                    <th>Fecha de nacimiento</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php for ($i = 1; $i <= $data['total_passengers']; $i++) { ?>
                                    <tr>
                                        <td><?= $data['title-' . $i] . ' ' . $data['firstname-' . $i] . ' ' . $data['lastname-' . $i]; ?></td>
                                        <td><?= $data['gender-' . $i]; ?></td>
                                        <td><?= $data['dob-' . $i]; ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="card mb-3">
                <div class="card-body">
                    <h5 class="card-title">Detalles de contacto</h5>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Nombre</th>
                                    <th>Correo electrónico</th>
                                    <th>Móvil</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><?= $data['t-firstname'] . ' ' . $data['t-lastname']; ?></td>
                                    <td><?= $data['t-email']; ?></td>
                                    <td><?= $data['t-mobile']; ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

           
      </main>
      <footer>
    <div class="footer-area footer-bg">
        <!-- New Airlines Section -->
<div class="footer-airlines">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="footer-widget privacy">
                    <div class="fw-title text-center">
                        <h3>Aerolíneas Populares</h3>
                    </div>
                    <div class="fw-link">
                        <div class="airlines-grid">
                            <div class="airlines-row">
                                <a href="american.php">Aerolínea Estadounidense</a>
                                <a href="frontier-airlines.php">Aerolíneas Frontier</a>
                                <a href="iberia-airline.php">Aerolíneas Iberia</a>
                            </div>
                            <div class="airlines-row">
                                <a href="jetblue-airline.php">Jetblue Airline</a>
                                <a href="spirit-airlines.php">Aerolíneas Spirit</a>
                                <a href="united-airline.php">Aerolíneas United</a>
                            </div>
                            <div class="airlines-row">
                                <a href="viva-airline.php">Aerolíneas Viva</a>
                                <a href="volaris-airlines.php">Aerolíneas Volaris</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Airlines Section -->
        
        <div class="footer-top">
            <div class="container">
                <div class="row">
                    <div class="col-xl-3 col-lg-4 col-md-6">
                        <div class="footer-widget">
                            <div class="footer-logo">
                                <a href="/"><img src="assets/images/viajerosbaratos.png" alt="footerlogo" width="278" height="49"></a>
                            </div>
                            <div class="footer-content">
                                <p><span translate="no"> viajerosbaratos.com </span>es una compañía de viajes global que ofrece reservas de vuelos independiente asequibles, experiencias de viaje personalizadas y soporte las 24 horas, los 7 días de la semana, lo que garantiza viajes fluidos y memorables en todo el mundo.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-2 col-lg-4 col-sm-4 ftr-hed">
                        <div class="footer-widget privacy">
                            <div class="fw-title">
                                <h4 class="title">Enlaces Rápidos</h4>
                            </div>
                            <div class="fw-link">
                                <ul>
                                  <li><a href="last-minute-trip">Viaje de último minuto</a></li>
                                  <li><a href="student-trips">Viajes para estudiantiles</a></li>
                                  <li><a href="travel-for-seniors">Viajes para mayores</a></li>
                                  <li><a href="military-trips">Viajes militares</a></li>
                                  <li><a href="domestic-flights">Vuelos domésticos</a></li>
                                  <li><a href="one-way-flights">Vuelos de ida</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-4 col-sm-4 ftr-hed">
                        <div class="footer-widget privacy">
                            <div class="fw-title">
                                <h4 class="title">Destinos populares</h4>
                            </div>
                            <div class="fw-link">
                                <ul>
                                  <li><a href="orlando">Orlando</a></li>
                                  <li><a href="fort-lauderdale">Fort Lauderdale</a></li>
                                  <li><a href="atlanta">Atlanta</a></li>
                                  <li><a href="los-angeles">Los Angeles</a></li>
                                  <li><a href="saint-john">San Juan</a></li>
                                  <li><a href="miami">Miami</a></li>
                                  <li><a href="houston">Houston</a></li>
                                  <li><a href="newark">Newark</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-4 col-sm-4 ftr-hed">
                        <div class="footer-widget privacy">
                            <div class="fw-title">
                                <h4 class="title">Enlaces útiles</h4>
                            </div>
                            <div class="fw-link">
                                <ul>
                                  <li><a href="about-us.php">Sobre nosotras</a></li>
                                  <li><a href="contact.php">Contacta con nosotras</a></li>
                                  <li><a href="cancelation">Cancelación</a></li>
                                  <li><a href="privacy-policy">Política de privacidad</a></li>
                                  <li><a href="sitemap">Mapa del sitio</a></li>
                                  <li><a href="terms-conditions">Términos y condiciones</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4 col-sm-8 ftr-hed">
                        <div class="footer-widget cnt-ftr">
                            <div class="fw-title">
                                <h4 class="title">Contacta con nosotras</h4>
                            </div>
                            <div class="footer-contact">
                              <ul>
                                <li><p><b>DIRECCIÓN</b><br> </p></li>
                                <li><a href="tel:+971-55-873-2462"><i class="fa fa-phone-alt"></i> +971-55-873-2462</a></li>
                                <li>
                                    <a href="mailto:info@viajerosbaratos.com">
                                        <i class="fa fa-envelope"></i> info@viajerosbaratos.com
                                    </a>
                                </li>
                                <li><a href=""><i class="fa fa-map-marker-alt"></i> Address :20178-001 IFZA Business Park, DDP, Silicon Oasis, Dubai, United Arab Emirates</a></li>
                              </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <p class="disclaimer"><strong>Descargo de responsabilidad:</strong> Estimados invitados, Bienvenidos a Viajerosbaratos. La información contenida en esta página está destinada únicamente a ser ejemplo. El sitio tiene información actualizada, precisa, completa y confiable que hemos trabajado arduamente para mantenerla actualizada. <span translate="no"> viajerosbaratos.com </span>generalmente analiza muchas cosas, como qué tan precisa es la información, cómo se conecta a otros sitios, qué tan disponible está el servicio y el contenido generado por el usuario. Garantizamos claridad y establecemos expectativas claras para todos los involucrados, minimizando sorpresas inesperadas. Si tiene alguna pregunta.</p>
              <div class="trust" bis_skin_checked="1">
                        <ul class="ftr-trustpilot">
                        <li><img src="assets/images/asta-logo.png" alt="asta" width="81" height="24"></li>
                        <li><img src="assets/images/cloudfare.png" alt="cloudfare" width="94" height="33"></li>
                        <li><img src="assets/images/godaddy-ssl.png" alt="godaddy" width="95" height="24"></li>
                        <li><img src="assets/images/mac2.png" alt="mac2" width="59" height="24"></li>
                        <li><img src="assets/images/newlogo.png" alt="newlogo" width="180" height="31"></li>
                        <li><img src="assets/images/arc.png" alt="trust" width="40" height="20"></li>
                        <li><img src="assets/images/trustpilot-logo.png" alt="trustpilot" width="115" height="28"></li>
                        </ul>
                        </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                    <div class="col-lg-12">
                        <div class="copyright-text text-center">
                            <p>Derechos de autor © 2024 <span translate="no">viajerosbaratos.com</span> | Reservados todos los derechos | Empresa matriz: <span translate="no"> Mark8er FZCO</span></p>
                        </div>
                    </div>
            </div>
        </div>
    </div>
</footer>



<style>
    /* Airlines Section Styles */
    .footer-airlines {
        background: #000000;
        padding: 30px 0;
        border-bottom: 1px solid #000000;
    }
    
    .fw-title h3 {
        color: #ffffff;
        font-size: 24px;
        font-weight: 600;
        margin-bottom: 20px;
        text-transform: uppercase;
    }
    
    .airlines-grid {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 15px;
        max-width: 800px;
        margin: 0 auto;
    }
    
    .airlines-row {
        display: flex;
        justify-content: center;
        gap: 30px;
        width: 100%;
    }
    
    .airlines-row a {
        color: #ffffff;
        text-decoration: none;
        font-size: 16px;
        font-weight: 500;
        padding: 8px 15px;
        border: 1px solid #333;
        border-radius: 4px;
        transition: all 0.3s ease;
        min-width: 180px;
        text-align: center;
    }
    
    .airlines-row a:hover {
        background: #333;
        color: #fff;
        transform: translateY(-2px);
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        .airlines-row {
            flex-direction: column;
            gap: 10px;
            align-items: center;
        }
        
        .airlines-row a {
            width: 80%;
        }
    }
</style>
      <a id="backTotop" href="#" class="to-top-icon">
        <i class="fas fa-chevron-up"></i>
      </a>
      <!-- custom search field html -->
      <div class="header-search-form">
        <div class="container">
          <div class="header-search-container">
            <form class="search-form" role="search" method="get">
              <input type="text" name="s" placeholder="Enter your text..." />
            </form>
            <a href="#" class="search-close">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div>
      </div>
      <!-- header html end -->
    </div>

    <div class="modal fade show" style="display: none;" id="aero_loader">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content sear-popup">
          <div class="modal-body py-0">
            <div class="container-fluid">
              <div class="row">
                <div class="col-12 search-top">
                  <div class="row text-center">
                    <div class="col-5 col-sm-5 col-lg-5 col-xl-5">
                      <h6 id="sourceAirportName"></h6>
                      <h2 id="sourceAirportCode"></h2>
                    </div>
                    <div class="col-2 col-sm-2 col-lg-2 col-xl-2">
                      <div class="search-aero"><i class="fa fa-long-arrow-left" aria-hidden="true"></i></div>
                      <div class="search-aero"><i class="fa fa-long-arrow-right" aria-hidden="true"></i></div>
                    </div>
                    <div class="col-5 col-sm-5 col-lg-5 col-xl-5">
                      <h6 id="destinationAirportName"></h6>
                      <h2 id="destinationAirportCode"></h2>
                    </div>
                  </div>
                </div>
              </div>
              <div class="row" style="background: white;">
                <div class="col-12 search-med text-center">
                  <div class="discountoffer">
                    <h6>Limited time Offer</h6>
                    <h5>Call Now For Exclusive Fares Deals</h5>
                    <br />
                    <img alt="Loader" loading="lazy" width="80" height="80" decoding="async" data-nimg="1" class="img-fluid" style="color: transparent;" src="assets/images/aeroplane_loader.gif" />
                    <p>+971-55-873-2462</p>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 search-date">
                  <ul>
                    <li>
                      <h6 class="mb-0">Depart</h6>
                      <p class="mb-0" id="departDate">2024-08-16</p>
                    </li>
                    <li>
                      <h6 class="mb-0">Return</h6>
                      <p class="mb-0">-</p>
                    </li>
                    <li>
                      <h6 class="mb-0">Travellers</h6>
                      <p class="mb-0" id="paxNo">1<!-- -->Pax</p>
                    </li>
                    <li>
                      <h6 class="mb-0">Class</h6>
                      <p class="mb-0">Economy</p>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- JavaScript -->
    <script src="assets/js/jquery.js"></script>
    <script src="http://cdnjs.cloudflare.com/ajax/libs/waypoints/2.0.3/waypoints.min.js"></script>
    <script src="assets/vendors/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/vendors/jquery-ui/jquery-ui.min.js"></script>
    <script src="assets/vendors/countdown-date-loop-counter/loopcounter.js"></script>
    <script src="assets/js/jquery.counterup.js"></script>
    <script src="assets/vendors/modal-video/jquery-modal-video.min.js"></script>
    <script src="assets/vendors/masonry/masonry.pkgd.min.js"></script>
    <script src="assets/vendors/lightbox/dist/js/lightbox.min.js"></script>
    <script src="assets/vendors/slick/slick.min.js"></script>
    <script src="assets/js/jquery.slicknav.js"></script>
    <script src="assets/js/custom.min.js"></script>
  </body>
</html>
